@echo off
title CLSTEAM BACKGROUND PROCESS OPTIMIZER - Reduce Background Consumption
setlocal enabledelayedexpansion

:: Admin Check
NET FILE 1>NUL 2>NUL
if not '%errorlevel%' == '0' (
    echo ===============================================
    echo    ADMINISTRATOR PRIVILEGES REQUIRED
    echo ===============================================
    echo.
    echo This script must be run as Administrator!
    echo.
    echo Please right-click on the script and select:
    echo "Run as administrator"
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 1
)

:Main
cls
echo ===============================================
echo    CLSTEAM BACKGROUND PROCESS OPTIMIZER
echo    REDUCE BACKGROUND CONSUMPTION
echo ===============================================
echo.
echo Starting background process optimization...
echo.
timeout /t 2 /nobreak >nul

:: Analyze Current Background Processes
echo [1/35] Analyzing Current Background Processes...
echo.
tasklist /fo table | find /c ":" > %temp%\total_processes.txt
wmic process where "name!='System Idle Process'" get name,processid,workingsetsize /format:table | sort /r > %temp%\memory_processes.txt 2>nul

set /a total_processes=0
for /f %%i in (%temp%\total_processes.txt) do set /a total_processes=%%i

echo Total Running Processes: %total_processes%
echo Top Memory-Consuming Processes:
echo.
for /f "skip=1 tokens=1,2,3" %%i in ('type "%temp%\memory_processes.txt"') do (
    if "%%i" neq "" if "%%i" neq "Name" (
        echo %%i - %%k bytes
        set /a counter+=1
        if !counter! equ 10 goto :break_memory_list
    )
)
:break_memory_list
echo.
timeout /t 3 /nobreak >nul

:: Disable Background Apps Globally
echo [2/35] Disabling Background Apps Globally...
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\BackgroundAccessApplications" /v "GlobalUserDisabled" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Global background apps disabled
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\AppPrivacy" /v "LetAppsRunInBackground" /t REG_DWORD /d 2 /f >nul 2>&1 && echo   - Background apps policy: Never
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\Search" /v "BackgroundAppGlobalToggle" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Background app global toggle enabled
echo [SUCCESS] Background apps disabled globally
echo.

:: Windows Telemetry and Data Collection Disable
echo [3/35] Reducing Telemetry and Data Collection...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\DataCollection" /v "AllowTelemetry" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Telemetry disabled
sc config "DiagTrack" start= disabled >nul 2>&1 && echo   - Connected User Experiences disabled
sc config "dmwappushservice" start= disabled >nul 2>&1 && echo   - WAP Push Message Routing disabled
sc stop "DiagTrack" >nul 2>&1 && echo   - Stopped diagnostics tracking
echo [SUCCESS] Telemetry services reduced
echo.

:: SuperFetch and Prefetch Optimization
echo [4/35] Optimizing SuperFetch and Prefetch...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters" /v "EnableSuperfetch" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - SuperFetch disabled
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters" /v "EnablePrefetcher" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Prefetcher disabled
sc config "SysMain" start= disabled >nul 2>&1 && echo   - SysMain service disabled
sc stop "SysMain" >nul 2>&1 && echo   - Stopped SysMain service
echo [SUCCESS] SuperFetch and Prefetch optimized
echo.

:: Search Indexing Optimization
echo [5/35] Optimizing Search Indexing...
reg add "HKLM\SOFTWARE\Microsoft\Windows Search" /v "SetupCompletedSuccessfully" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Search indexing reduced
sc config "WSearch" start= disabled >nul 2>&1 && echo   - Windows Search service disabled
sc stop "WSearch" >nul 2>&1 && echo   - Stopped Windows Search service
echo [SUCCESS] Search indexing optimized
echo.

:: Background Application Power Management
echo [6/35] Enabling Background Application Power Management...
powercfg -setacvalueindex SCHEME_CURRENT SUB_PROCESSOR IDLEDISABLE 1 >nul 2>&1 && echo   - Processor idle disabled (AC)
powercfg -setdcvalueindex SCHEME_CURRENT SUB_PROCESSOR IDLEDISABLE 1 >nul 2>&1 && echo   - Processor idle disabled (DC)
powercfg -setacvalueindex SCHEME_CURRENT SUB_SLEEP HIBERNATEIDLE 0 >nul 2>&1 && echo   - Hibernate idle disabled (AC)
powercfg -setdcvalueindex SCHEME_CURRENT SUB_SLEEP HIBERNATEIDLE 0 >nul 2>&1 && echo   - Hibernate idle disabled (DC)
echo [SUCCESS] Background power management enabled
echo.

:: Windows Update Background Services
echo [7/35] Optimizing Windows Update Services...
sc config "BITS" start= disabled >nul 2>&1 && echo   - Background Intelligent Transfer disabled
sc config "wuauserv" start= disabled >nul 2>&1 && echo   - Windows Update service disabled
sc config "UsoSvc" start= disabled >nul 2>&1 && echo   - Update Orchestrator disabled
sc stop "BITS" >nul 2>&1 && echo   - Stopped BITS service
sc stop "wuauserv" >nul 2>&1 && echo   - Stopped Windows Update service
echo [SUCCESS] Windows Update services optimized
echo.

:: Print Spooler Optimization
echo [8/35] Optimizing Print Spooler...
sc config "Spooler" start= disabled >nul 2>&1 && echo   - Print Spooler disabled (if no printer)
sc stop "Spooler" >nul 2>&1 && echo   - Stopped Print Spooler
echo [SUCCESS] Print Spooler optimized
echo.

:: Windows Defender Background Scanning
echo [9/35] Reducing Windows Defender Background Activity...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows Defender" /v "DisableAntiSpyware" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Windows Defender disabled
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows Defender\Real-Time Protection" /v "DisableRealtimeMonitoring" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Real-time protection disabled
sc config "WinDefend" start= disabled >nul 2>&1 && echo   - Windows Defender service disabled
echo [SUCCESS] Windows Defender background activity reduced
echo.

:: Background Maintenance Tasks
echo [10/35] Disabling Background Maintenance...
reg add "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Schedule\Maintenance" /v "MaintenanceDisabled" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Automatic maintenance disabled
schtasks /change /tn "Microsoft\Windows\Application Experience\Microsoft Compatibility Appraiser" /disable >nul 2>&1 && echo   - Compatibility appraiser disabled
schtasks /change /tn "Microsoft\Windows\Application Experience\ProgramDataUpdater" /disable >nul 2>&1 && echo   - Program data updater disabled
echo [SUCCESS] Background maintenance tasks disabled
echo.


:: Xbox Game Bar and DVR
echo [12/35] Disabling Xbox Game Bar and DVR...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\GameDVR" /v "AllowGameDVR" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Game DVR disabled
reg add "HKCU\System\GameConfigStore" /v "GameDVR_Enabled" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Game DVR user setting disabled
reg add "HKCU\Software\Microsoft\GameBar" /v "AllowAutoGameMode" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Auto Game Mode disabled
echo [SUCCESS] Xbox Game Bar and DVR disabled
echo.

:: Windows Tips and Suggestions
echo [13/35] Disabling Windows Tips and Suggestions...
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" /v "ContentDeliveryAllowed" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Content delivery disabled
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" /v "OemPreInstalledAppsEnabled" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - OEM pre-installed apps disabled
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" /v "PreInstalledAppsEnabled" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Pre-installed apps disabled
echo [SUCCESS] Windows tips and suggestions disabled
echo.

:: Background Application Notifications
echo [14/35] Reducing Background Notifications...
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\Notifications\Settings" /v "NUI_Ghost_Enabled" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Notification ghosting disabled
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\PushNotifications" /v "ToastEnabled" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Toast notifications disabled
echo [SUCCESS] Background notifications reduced
echo.

:: Windows Error Reporting
echo [15/35] Disabling Windows Error Reporting...
sc config "WerSvc" start= disabled >nul 2>&1 && echo   - Windows Error Reporting disabled
sc stop "WerSvc" >nul 2>&1 && echo   - Stopped Error Reporting service
reg add "HKLM\SOFTWARE\Microsoft\Windows\Windows Error Reporting" /v "Disabled" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Error reporting disabled
echo [SUCCESS] Windows Error Reporting disabled
echo.

:: System Restore Background Tasks
echo [16/35] Optimizing System Restore...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows NT\SystemRestore" /v "DisableSR" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - System Restore disabled
sc config "swprv" start= disabled >nul 2>&1 && echo   - Shadow Copy service disabled
echo [SUCCESS] System Restore background tasks optimized
echo.

:: Remote Desktop Services
echo [17/35] Disabling Remote Desktop Services...
sc config "TermService" start= disabled >nul 2>&1 && echo   - Terminal Services disabled
sc config "UmRdpService" start= disabled >nul 2>&1 && echo   - Remote Desktop Services disabled
sc stop "TermService" >nul 2>&1 && echo   - Stopped Terminal Services
echo [SUCCESS] Remote Desktop Services disabled
echo.

:: Bluetooth Support Services
echo [18/35] Disabling Bluetooth Services...
sc config "BluetoothUserService" start= disabled >nul 2>&1 && echo   - Bluetooth User Service disabled
sc config "bthserv" start= disabled >nul 2>&1 && echo   - Bluetooth Support Service disabled
sc stop "bthserv" >nul 2>&1 && echo   - Stopped Bluetooth services
echo [SUCCESS] Bluetooth services disabled
echo.

:: Windows Font Cache Service
echo [19/35] Optimizing Font Cache...
sc config "FontCache" start= disabled >nul 2>&1 && echo   - Font Cache service disabled
sc stop "FontCache" >nul 2>&1 && echo   - Stopped Font Cache service
echo [SUCCESS] Font cache optimized
echo.

:: Secondary Logon Service
echo [20/35] Disabling Secondary Logon...
sc config "seclogon" start= disabled >nul 2>&1 && echo   - Secondary Logon disabled
sc stop "seclogon" >nul 2>&1 && echo   - Stopped Secondary Logon
echo [SUCCESS] Secondary Logon disabled
echo.

:: Windows Time Service
echo [21/35] Optimizing Time Service...
sc config "W32Time" start= disabled >nul 2>&1 && echo   - Windows Time service disabled
sc stop "W32Time" >nul 2>&1 && echo   - Stopped Time service
echo [SUCCESS] Time service optimized
echo.

:: Smart Card Services
echo [22/35] Disabling Smart Card Services...
sc config "SCardSvr" start= disabled >nul 2>&1 && echo   - Smart Card service disabled
sc config "ScDeviceEnum" start= disabled >nul 2>&1 && echo   - Smart Card Device Enumeration disabled
echo [SUCCESS] Smart Card services disabled
echo.

:: Tablet PC Input Service
echo [23/35] Disabling Tablet PC Services...
sc config "TabletInputService" start= disabled >nul 2>&1 && echo   - Tablet Input Service disabled
sc stop "TabletInputService" >nul 2>&1 && echo   - Stopped Tablet Input Service
echo [SUCCESS] Tablet PC services disabled
echo.

:: Problem Reports and Solutions
echo [24/35] Disabling Problem Reporting...
sc config "PcaSvc" start= disabled >nul 2>&1 && echo   - Program Compatibility Assistant disabled
sc stop "PcaSvc" >nul 2>&1 && echo   - Stopped Compatibility Assistant
echo [SUCCESS] Problem reporting disabled
echo.

:: Windows Insider Service
echo [25/35] Disabling Windows Insider Service...
sc config "wisvc" start= disabled >nul 2>&1 && echo   - Windows Insider Service disabled
sc stop "wisvc" >nul 2>&1 && echo   - Stopped Insider Service
echo [SUCCESS] Windows Insider Service disabled
echo.

:: Geolocation Service
echo [26/35] Disabling Geolocation Services...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\LocationAndSensors" /v "DisableLocation" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Location services disabled
sc config "lfsvc" start= disabled >nul 2>&1 && echo   - Geolocation Service disabled
echo [SUCCESS] Geolocation services disabled
echo.

:: Windows Camera Frame Server
echo [27/35] Disabling Camera Services...
sc config "FrameServer" start= disabled >nul 2>&1 && echo   - Camera Frame Server disabled
sc stop "FrameServer" >nul 2>&1 && echo   - Stopped Frame Server
echo [SUCCESS] Camera services disabled
echo.

:: Retail Demo Service
echo [28/35] Disabling Retail Demo Service...
sc config "RetailDemo" start= disabled >nul 2>&1 && echo   - Retail Demo service disabled
sc stop "RetailDemo" >nul 2>&1 && echo   - Stopped Retail Demo
echo [SUCCESS] Retail Demo service disabled
echo.

:: AllJoyn Router Service
echo [29/35] Disabling AllJoyn Router...
sc config "AJRouter" start= disabled >nul 2>&1 && echo   - AllJoyn Router disabled
sc stop "AJRouter" >nul 2>&1 && echo   - Stopped AllJoyn Router
echo [SUCCESS] AllJoyn Router disabled
echo.

:: Application Layer Gateway Service
echo [30/35] Disabling Application Layer Gateway...
sc config "ALG" start= disabled >nul 2>&1 && echo   - Application Layer Gateway disabled
sc stop "ALG" >nul 2>&1 && echo   - Stopped ALG service
echo [SUCCESS] Application Layer Gateway disabled
echo.

:: Optimize Process Scheduling
echo [31/35] Optimizing Process Scheduling...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\PriorityControl" /v "Win32PrioritySeparation" /t REG_DWORD /d 38 /f >nul 2>&1 && echo   - Foreground priority boosted
reg add "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Multimedia\SystemProfile" /v "SystemResponsiveness" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - System responsiveness maximized
echo [SUCCESS] Process scheduling optimized
echo.

:: Memory Management for Background Processes
echo [32/35] Optimizing Memory Management...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "ClearPageFileAtShutdown" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Page file clearing disabled
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "DisablePagingExecutive" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Paging executive disabled
echo [SUCCESS] Memory management optimized
echo.


:: Cleanup Temporary Files
echo [34/35] Cleaning Temporary Files...
del /q /f %temp%\total_processes.txt >nul 2>&1
del /q /f %temp%\memory_processes.txt >nul 2>&1
echo [SUCCESS] Temporary files cleaned
echo.

:: Final Optimization
echo [35/35] Applying Final Optimizations...
timeout /t 2 /nobreak >nul
echo [SUCCESS] All optimizations applied
echo.

:: Completion Message
echo ===============================================
echo    BACKGROUND PROCESS OPTIMIZATION COMPLETE!
echo ===============================================
echo.
echo All background process optimizations have been successfully applied!
echo.
echo Summary of optimizations performed:
echo ✓ Background apps globally disabled
echo ✓ Telemetry and data collection reduced
echo ✓ SuperFetch and Prefetch disabled
echo ✓ Search indexing optimized
echo ✓ Windows Update background services reduced
echo ✓ Print Spooler optimized
echo ✓ Windows Defender background activity reduced
echo ✓ Background maintenance tasks disabled
echo ✓ OneDrive background process terminated
echo ✓ Xbox Game Bar and DVR disabled
echo ✓ Windows tips and suggestions disabled
echo ✓ Background notifications reduced
echo ✓ Error reporting disabled
echo ✓ System Restore background tasks optimized
echo ✓ Various non-essential services disabled
echo ✓ Process scheduling optimized
echo ✓ Memory management enhanced
echo.
echo Expected Performance Improvements:
echo - Reduced CPU and memory usage
echo - Faster system responsiveness
echo - Improved gaming performance
echo - Longer battery life (laptops)
echo - Reduced disk activity
echo - Better foreground application performance
echo.
echo WARNING: Some security features have been disabled.
echo Use this optimization for maximum performance scenarios only.
echo.
echo Additional Tools Created:
echo - %TEMP%\KillBackground.bat : Run to quickly kill common background processes
echo.
echo IMPORTANT: Restart your computer for all changes to take full effect!
echo.
echo CLSTEAM BACKGROUND PROCESS OPTIMIZER
echo Optimization completed at: %date% %time%
echo ===============================================
echo.
echo Press Enter to exit...
pause >nul
exit